{ $HDR$}
{**********************************************************************}
{ Unit archived using Team Coherence                                   }
{ Team Coherence is Copyright 2002 by Quality Software Components      }
{                                                                      }
{ For further information / comments, visit our WEB site at            }
{ http://www.TeamCoherence.com                                         }
{**********************************************************************}
{}
{ $Log:  12004: IdTCPStream.pas 
{
{   Rev 1.6    5/12/2003 9:17:58 AM  GGrieve
{ remove dead code
}
{
{   Rev 1.5    5/12/2003 12:32:14 AM  GGrieve
{ Refactor to work under DotNet
}
{
{   Rev 1.4    10/10/2003 11:04:24 PM  BGooijen
{ DotNet
}
{
{   Rev 1.3    9/10/2003 1:50:50 PM  SGrobety
{ DotNet
}
{
{   Rev 1.2    2003.10.01 11:16:38 AM  czhower
{ .Net
}
{
{   Rev 1.1    2003.10.01 1:37:36 AM  czhower
{ .Net
}
{
{   Rev 1.0    11/13/2002 09:01:04 AM  JPMugaas
}
unit IdTCPStream;

{$I IdCompilerDefines.inc}

interface

uses
  Classes,
  IdCoreGlobal,
  IdTCPConnection;

type

  // S.G. 09/10/2003: ToDo - Rework the stream system to use stream proxies instead of streams directly

  TIdTCPStream = class(TIdBaseStream)
  protected
    FConnection: TIdTCPConnection;
    function IdRead(var VBuffer: TIdBytes; AOffset, ACount: Longint): Longint; override;
    function IdWrite(const ABuffer: TIdBytes; AOffset, ACount: Longint): Longint; override;
    function IdSeek(const AOffset: Int64; AOrigin: TSeekOrigin): Int64; override;
    procedure IdSetSize(ASize : Int64); override;
  public
    constructor Create(AConnection: TIdTCPConnection); reintroduce;
    property Connection: TIdTCPConnection read FConnection;
  end;

implementation


{ TIdTCPStream }

constructor TIdTCPStream.Create(AConnection: TIdTCPConnection);
begin
  inherited Create;
  FConnection := AConnection;
end;

function TIdTCPStream.IdRead(var VBuffer: TIdBytes; AOffset, ACount: Longint): Longint;
begin
  Connection.IOHandler.ReadBytes(VBuffer, ACount);
  Result := ACount;
end;

function TIdTCPStream.IdWrite(const ABuffer: TIdBytes; AOffset, ACount: Longint): Longint;
begin
  Connection.IOHandler.WriteBytes(ABuffer, true{AWriteNow});
  Result := Length(ABuffer);
end;

function TIdTCPStream.IdSeek(const AOffset: Int64; AOrigin: TSeekOrigin): Int64;
begin
  Result := -1;
end;

procedure TIdTCPStream.IdSetSize(ASize : Int64);
begin
end;

end.

